	
	// Filter SimpleElegent
__kernel void filter_SimpleElegent(__read_only image2d_t image,   		// input image
								   __global int* tableR,     			// input buffer table R
								   __global int* tableG,     			// input buffer table G
								   __global int* tableB,     			// input buffer table B
								   __global uchar* table,  				// image input buffer
								   __write_only image2d_t retImage,   	// image result
								   __private int en,
								   __private int alpha)	 				// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	

	float4 color = read_imagef(image, sampler, (int2)(w, h));
	uchar sr = convert_uchar_sat(color.x * 255.0f);
	uchar sg = convert_uchar_sat(color.y * 255.0f);
	uchar sb = convert_uchar_sat(color.z * 255.0f);
	
	int gray = (tableR[sr] + tableG[sg] + tableB[sb] + 512) >> 10;
	int newgray = gray * en;
	int de = 256 - en;
	
	int r = (sr * de + newgray) >> 8;
	int g = (sg * de + newgray) >> 8;
	int b = (sb * de + newgray) >> 8;
	
	float4 retColor = (float4)(table[r] / 255.0f, table[g] / 255.0f, table[b] / 255.0f, color.w);
	float factor = (float)(alpha)/100.0f;
	
	retColor = retColor * factor + (1.0f - factor) * color;
	write_imagef(retImage, (int2)(w, h), retColor);
}